/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.util.encoders.Hex;

public class RoleBasedFieldMasking
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedFieldMasking.class);
    private final SgDynamicConfiguration<Role> roles;
    private final StaticIndexRules staticIndexQueries;
    private volatile StatefulIndexRules statefulIndexQueries;
    private final ComponentState componentState = new ComponentState("role_based_field_masking");
    private final DlsFlsConfig.FieldMasking fieldMaskingConfig;

    public RoleBasedFieldMasking(SgDynamicConfiguration<Role> roles, DlsFlsConfig.FieldMasking fieldMaskingConfig, Set<String> indices, MetricsLevel metricsLevel) {
        this.roles = roles;
        this.fieldMaskingConfig = fieldMaskingConfig;
        this.staticIndexQueries = new StaticIndexRules(roles, fieldMaskingConfig);
        this.statefulIndexQueries = new StatefulIndexRules(roles, fieldMaskingConfig, indices);
        this.componentState.setInitialized();
        this.componentState.setConfigVersion(roles.getDocVersion());
        this.componentState.addPart(this.statefulIndexQueries.getComponentState());
        this.componentState.addPart(this.staticIndexQueries.getComponentState());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public FieldMaskingRule getFieldMaskingRule(PrivilegesEvaluationContext context, String index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("evaluate_fm");){
            Object object;
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                FieldMaskingRule fieldMaskingRule = FieldMaskingRule.ALLOW_ALL;
                return fieldMaskingRule;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.contains((Object)index)) {
                FieldMaskingRule fieldMaskingRule = FieldMaskingRule.MASK_ALL;
                return fieldMaskingRule;
            }
            ImmutableSet rolesWithoutRule = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutRule.get((Object)index);
            if (rolesWithoutRule != null && rolesWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                FieldMaskingRule fieldMaskingRule = FieldMaskingRule.ALLOW_ALL;
                return fieldMaskingRule;
            }
            ImmutableMap roleToRule = (ImmutableMap)this.statefulIndexQueries.indexToRoleToRule.get((Object)index);
            ArrayList<FieldMaskingRule.SingleRole> rules = new ArrayList<FieldMaskingRule.SingleRole>();
            for (String role : context.getMappedRoles()) {
                ImmutableMap indexPatternTemplateToQuery;
                FieldMaskingRule.SingleRole rule = (FieldMaskingRule.SingleRole)this.staticIndexQueries.roleWithIndexWildcardToRule.get((Object)role);
                if (rule != null) {
                    rules.add(rule);
                }
                if (roleToRule != null && (rule = (FieldMaskingRule.SingleRole)roleToRule.get((Object)role)) != null) {
                    rules.add(rule);
                }
                if ((indexPatternTemplateToQuery = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToRule.get((Object)role)) == null) continue;
                for (Map.Entry entry : indexPatternTemplateToQuery.entrySet()) {
                    try {
                        Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                        if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                        rules.add((FieldMaskingRule.SingleRole)entry.getValue());
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if (rules.isEmpty()) {
                object = FieldMaskingRule.ALLOW_ALL;
                return object;
            }
            object = new FieldMaskingRule.MultiRole(rules);
            return object;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("evaluate", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("evaluate_u", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasFieldMaskingRestrictions(PrivilegesEvaluationContext context, Collection<String> indices, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("has_fm_restriction");){
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.containsAll(indices)) {
                boolean bl = true;
                return bl;
            }
            for (String index : indices) {
                if (!this.hasFieldMaskingRestrictions(context, index, statefulIndexQueries)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_restriction_u", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasFieldMaskingRestrictions(PrivilegesEvaluationContext context, String index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("has_fm_restriction");){
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.contains((Object)index)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasFieldMaskingRestrictions(context, index, statefulIndexQueries);
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_restriction_u", (Throwable)e);
            throw e;
        }
    }

    private boolean hasFieldMaskingRestrictions(PrivilegesEvaluationContext context, String index, StatefulIndexRules statefulIndexQueries) throws PrivilegesEvaluationException {
        ImmutableSet roleWithoutRule = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutRule.get((Object)index);
        if (roleWithoutRule != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return false;
        }
        ImmutableMap roleToRule = (ImmutableMap)statefulIndexQueries.indexToRoleToRule.get((Object)index);
        for (String role : context.getMappedRoles()) {
            FieldMaskingRule rule = (FieldMaskingRule)this.staticIndexQueries.roleWithIndexWildcardToRule.get((Object)role);
            if (rule != null) {
                return true;
            }
            if (roleToRule != null && (rule = (FieldMaskingRule)roleToRule.get((Object)role)) != null) {
                return true;
            }
            ImmutableMap indexPatternTemplateToRule = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToRule.get((Object)role);
            if (indexPatternTemplateToRule == null) continue;
            for (Map.Entry entry : indexPatternTemplateToRule.entrySet()) {
                try {
                    Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                    if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                    return true;
                }
                catch (ExpressionEvaluationException e) {
                    throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                }
            }
        }
        return false;
    }

    public synchronized void updateIndices(Set<String> indices) {
        StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
        if (!statefulIndexQueries.indices.equals(indices)) {
            this.statefulIndexQueries = new StatefulIndexRules(this.roles, this.fieldMaskingConfig, indices);
            this.componentState.replacePart(this.statefulIndexQueries.getComponentState());
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public DlsFlsConfig.FieldMasking getFieldMaskingConfig() {
        return this.fieldMaskingConfig;
    }

    public static abstract class FieldMaskingRule {
        public static final FieldMaskingRule ALLOW_ALL = new SingleRole((ImmutableList<Field>)ImmutableList.empty());
        public static final FieldMaskingRule MASK_ALL = new SingleRole((ImmutableList<Field>)ImmutableList.of((Object)new Field(Role.Index.FieldMaskingExpression.MASK_ALL, DlsFlsConfig.FieldMasking.DEFAULT)));

        public static FieldMaskingRule of(DlsFlsConfig.FieldMasking fieldMaskingConfig, String ... rules) throws ConfigValidationException {
            ImmutableList.Builder patterns = new ImmutableList.Builder();
            for (String rule : rules) {
                patterns.add((Object)new Role.Index.FieldMaskingExpression(rule));
            }
            return new SingleRole((ImmutableList<Field>)patterns.build().map(e -> new Field((Role.Index.FieldMaskingExpression)e, fieldMaskingConfig)));
        }

        public abstract Field get(String var1);

        public abstract boolean isAllowAll();

        static String stripKeywordSuffix(String field) {
            if (field.endsWith(".keyword")) {
                return field.substring(0, field.length() - ".keyword".length());
            }
            return field;
        }

        public static class Field {
            private final Role.Index.FieldMaskingExpression expression;
            private final byte[] salt;
            private final byte[] personalization;
            private final byte[] prefix;

            Field(Role.Index.FieldMaskingExpression expression, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
                this.expression = expression;
                this.salt = fieldMaskingConfig.getSalt();
                this.personalization = fieldMaskingConfig.getPersonalization();
                this.prefix = fieldMaskingConfig.getPrefix() != null ? fieldMaskingConfig.getPrefix().getBytes() : null;
            }

            public Pattern getPattern() {
                return this.expression.getPattern();
            }

            public byte[] apply(byte[] value) {
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public String apply(String value) {
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public BytesRef apply(BytesRef value) {
                if (value == null) {
                    return null;
                }
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public String toString() {
                return this.expression.toString();
            }

            private boolean isDefault() {
                return this.expression.getAlgo() == null && this.expression.getRegexReplacements() == null;
            }

            private byte[] customHash(byte[] in) {
                MessageDigest algo = this.expression.getAlgo();
                if (algo != null) {
                    if (this.prefix != null) {
                        return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])algo.digest(in))});
                    }
                    return Hex.encode((byte[])algo.digest(in));
                }
                if (this.expression.getRegexReplacements() != null) {
                    String string = new String(in, StandardCharsets.UTF_8);
                    for (Role.Index.FieldMaskingExpression.RegexReplacement rr : this.expression.getRegexReplacements()) {
                        string = rr.getRegex().matcher(string).replaceAll(rr.getReplacement());
                    }
                    if (this.prefix != null) {
                        return Bytes.concat((byte[][])new byte[][]{this.prefix, string.getBytes(StandardCharsets.UTF_8)});
                    }
                    return string.getBytes(StandardCharsets.UTF_8);
                }
                throw new IllegalArgumentException();
            }

            private BytesRef customHash(BytesRef in) {
                BytesRef copy = BytesRef.deepCopyOf((BytesRef)in);
                return new BytesRef(this.customHash(copy.bytes));
            }

            private String customHash(String in) {
                return new String(this.customHash(in.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }

            private byte[] blake2bHash(byte[] in) {
                Blake2bDigest hash = new Blake2bDigest(null, 32, this.salt, this.personalization);
                hash.update(in, 0, in.length);
                byte[] out = new byte[hash.getDigestSize()];
                hash.doFinal(out, 0);
                if (this.prefix != null) {
                    return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])out)});
                }
                return Hex.encode((byte[])out);
            }

            private BytesRef blake2bHash(BytesRef in) {
                BytesRef copy = BytesRef.deepCopyOf((BytesRef)in);
                return new BytesRef(this.blake2bHash(copy.bytes));
            }

            private String blake2bHash(String in) {
                return new String(this.blake2bHash(in.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
        }

        public static class MultiRole
        extends FieldMaskingRule {
            final ImmutableList<SingleRole> parts;
            final boolean allowAll;

            MultiRole(Collection<SingleRole> parts) {
                this.parts = ImmutableList.of(parts);
                this.allowAll = this.parts.forAnyApplies(p -> p.isAllowAll());
            }

            @Override
            public Field get(String field) {
                field = MultiRole.stripKeywordSuffix(field);
                Field masking = null;
                for (SingleRole part : this.parts) {
                    masking = part.get(field);
                    if (masking != null) continue;
                    return null;
                }
                return masking;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:*";
                }
                return "FM:" + this.parts.map(p -> p.expressions);
            }
        }

        public static class SingleRole
        extends FieldMaskingRule {
            final Role sourceRole;
            final Role.Index sourceIndex;
            final ImmutableList<Field> expressions;

            SingleRole(Role sourceRole, Role.Index sourceIndex, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
                this.sourceRole = sourceRole;
                this.sourceIndex = sourceIndex;
                this.expressions = ImmutableList.of((Collection)sourceIndex.getMaskedFields().stream().map(e -> new Field((Role.Index.FieldMaskingExpression)e, fieldMaskingConfig)).collect(Collectors.toList()));
            }

            SingleRole(ImmutableList<Field> expressions) {
                this.sourceIndex = null;
                this.sourceRole = null;
                this.expressions = expressions;
            }

            @Override
            public Field get(String field) {
                return this.internalGet(SingleRole.stripKeywordSuffix(field));
            }

            private Field internalGet(String field) {
                for (Field expression : this.expressions) {
                    if (!expression.getPattern().matches(field)) continue;
                    return expression;
                }
                return null;
            }

            @Override
            public boolean isAllowAll() {
                return this.expressions.isEmpty();
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:*";
                }
                return "FM:" + this.expressions;
            }
        }
    }

    static class StatefulIndexRules
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<String, FieldMaskingRule.SingleRole>> indexToRoleToRule;
        private final ImmutableMap<String, ImmutableSet<String>> indexToRoleWithoutRule;
        private final ImmutableSet<String> indices;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        private final ComponentState componentState;

        StatefulIndexRules(SgDynamicConfiguration<Role> roles, DlsFlsConfig.FieldMasking fieldMaskingConfig, Set<String> indices) {
            this.indices = ImmutableSet.of(indices);
            this.componentState = new ComponentState("stateful_index_queries");
            ImmutableMap.Builder indexToRoleToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder indexToRoleWithoutRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                        if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                        ImmutableList fmExpressions = indexPermissions.getMaskedFields();
                        if (fmExpressions != null && !fmExpressions.isEmpty()) {
                            FieldMaskingRule.SingleRole fmRule = new FieldMaskingRule.SingleRole(role, indexPermissions, fieldMaskingConfig);
                            for (String index : indexPattern.iterateMatching(indices)) {
                                ((ImmutableMap.Builder)indexToRoleToRule.get((Object)index)).put((Object)roleName, (Object)fmRule);
                            }
                            continue;
                        }
                        for (String index : indexPattern.iterateMatching(indices)) {
                            ((ImmutableSet.Builder)indexToRoleWithoutRule.get((Object)index)).add((Object)roleName);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.indexToRoleToRule = indexToRoleToRule.build(b -> b.build());
            this.indexToRoleWithoutRule = indexToRoleWithoutRule.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class StaticIndexRules
    implements ComponentStateProvider {
        private final ComponentState componentState = new ComponentState("static_index_rules");
        private final ImmutableSet<String> rolesWithIndexWildcardWithoutRule;
        private final ImmutableMap<String, FieldMaskingRule.SingleRole> roleWithIndexWildcardToRule;
        private final ImmutableMap<String, ImmutableMap<Role.IndexPatterns.IndexPatternTemplate, FieldMaskingRule.SingleRole>> rolesToIndexPatternTemplateToRule;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;

        StaticIndexRules(SgDynamicConfiguration<Role> roles, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
            ImmutableSet.Builder rolesWithIndexWildcardWithoutRule = new ImmutableSet.Builder();
            ImmutableMap.Builder roleWithIndexWildcardToRule = new ImmutableMap.Builder();
            ImmutableMap.Builder rolesToIndexPatternTemplateToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        if (indexPermissions.getIndexPatterns().getPattern().isWildcard()) {
                            ImmutableList fmExpression = indexPermissions.getMaskedFields();
                            if (fmExpression == null || fmExpression.isEmpty()) {
                                rolesWithIndexWildcardWithoutRule.add((Object)roleName);
                                continue;
                            }
                            FieldMaskingRule.SingleRole fmRule = new FieldMaskingRule.SingleRole(role, indexPermissions, fieldMaskingConfig);
                            roleWithIndexWildcardToRule.put((Object)roleName, (Object)fmRule);
                            continue;
                        }
                        for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : indexPermissions.getIndexPatterns().getPatternTemplates()) {
                            ImmutableList fmExpression = indexPermissions.getMaskedFields();
                            if (fmExpression == null || fmExpression.isEmpty()) continue;
                            FieldMaskingRule.SingleRole fmRule = new FieldMaskingRule.SingleRole(role, indexPermissions, fieldMaskingConfig);
                            ((ImmutableMap.Builder)rolesToIndexPatternTemplateToRule.get((Object)roleName)).put((Object)indexPatternTemplate, (Object)fmRule);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.rolesWithIndexWildcardWithoutRule = rolesWithIndexWildcardWithoutRule.build();
            this.roleWithIndexWildcardToRule = roleWithIndexWildcardToRule.build();
            this.rolesToIndexPatternTemplateToRule = rolesToIndexPatternTemplateToRule.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

